<?php

function ioncube_event_handler($err_code, $params) {
    require_once _SRV_WEBROOT . _SRV_WEB_PLUGINS . 'xgx_cronus/classes/XgxCronusLicenseManager.php';

    switch ($err_code) {
        // ION_LICENSE_NOT_FOUND
        case '6':
        case '10':
            $message = 'No valid License file found for XGX USP Boxes, please copy your License file into your Shop. If you need help please contact support@xgx.at. Plugin is now disabled.';
            break;
        // ION_LICENSE_CORRUPT
        case '7':
            $message = 'License file for XGX USP Boxes corrupt, please contact support@xgx.at. Plugin is now disabled.';
            break;
        // ION_LICENSE_EXPIRED
        case '8':
            $message = 'License file for XGX USP Boxes expired, please contact support@xgx.at. Plugin is now disabled.';
            break;
        // ION_LICENSE_SERVER_INVALID
        case '11':
            $message = 'Domain/Server in License file for XGX USP Boxes is not matching the installed Domain/Server, please contact support@xgx.at. Plugin is now disabled.';
            break;
        default:
            $message = 'License error for XGX USP Boxes! Error Code:'.$err_code . ' Plugin is now disabled.';
            break;
    }

    XgxCronusLicenseManager::sayGoodbyeAndDisablePlugin($message, 'xgx_usp_boxes', $params, $err_code);*/
}