<?php
include_once _SRV_WEBROOT . _SRV_WEB_PLUGINS . 'xtlive_elements/includes/xtlive_functions.php';

function ioncube_event_handler($err_code,$params) {
    global $logHandler;

    switch ($err_code) {
        // ION_LICENSE_NOT_FOUND
        case '6':
        case '10':
            $msg = 'No valid License file found for XTLIVE Elements, please copy your License file into your Shop. If you need help please contact help@xtlive.at. XTLIVE is now disabled.';
            break;
        // ION_LICENSE_CORRUPT
        case '7':
            $msg = 'License file for XTLIVE Elements corrupt, please contact help@xtlive.at. XTLIVE is now disabled.';
            break;
        // ION_LICENSE_EXPIRED
        case '8':
            $msg = 'License file for XTLIVE Elements expired, please contact help@xtlive.at. XTLIVE is now disabled.';
            break;
        // ION_LICENSE_SERVER_INVALID
        case '11':
            $msg = 'Domain/Server in License file for XTLIVE Elements is not matching the installed Domain/Server, please contact help@xtlive.at. XTLIVE is now disabled.';
            break;
        default:
            $msg = 'License error for XTLIVE Elements! Error Code:'.$err_code . ' XTLIVE is now disabled.';
            break;
    }
    $logHandler->_addLog('error', 'xtlive_elements', 0, array('error_code' => $err_code, 'message' => $msg));
    disableXtLive();
}