CKEDITOR.plugins.add('moveContentLeft', {
    icons: 'moveContentLeft',
    init: function(editor) {
        editor.addCommand('moveContentLeft', {
            exec: function(editor) {
                var $startElement = $(editor.getSelection().getStartElement().$),
                    $moveElement = $startElement.closest('.moveable');

                if($moveElement && $moveElement.length > 0){
                    var $prevElement = $moveElement.prev('.moveable');

                    if($prevElement && $prevElement.length > 0){
                        var $element1 = $moveElement.clone();
                        var $element2 = $prevElement.clone();

                        $moveElement.replaceWith($element2);
                        $prevElement.replaceWith($element1);

                        editor.widgets.checkWidgets()
                    }else{
                        alert("You cant move to right");
                    }
                }else{
                    alert("No '.moveable' class found");
                }
            }
        });

        editor.ui.addButton('moveContentLeft', {
            label: 'Move Element Left',
            command: 'moveContentLeft',
            toolbar: 'others,0'
        });

    }
});