CKEDITOR.dialog.add( 'templateEditorDialog', function( editor ) {
    return {
        title: 'Inhalt einfügen',
        minWidth: 300,
        minHeight: 100,
        contents: [
            {
                id: 'contentTypeSelectionTab',
                label: 'Typ des Inhalts',
                elements: [
                    {
                        id: 'contentType',
                        label: 'Typ',
                        type: 'select',
                        items: [ [ 'Überschrift 2', 'h2' ],['Überschrift 3', 'h3' ],['Überschrift 4' , 'h4'],['Überschrift 5' , 'h5'],['Überschrift 6' , 'h6'], ['Absatztext', 'p'], ['Absatztext groß', 'p.lead'],['XTLIVE Button','btn-xtlive'],['XTLIVE Button groß','btn-xtlive-big']],

                        onChange: function ( data ) {
                            // watch onChange events for select boxes
                            // console.log('on change');
                        },

                        setup: function(data){

                        },

                        commit: function(data){

                        }
                    }
                ]
            },
        ],

        onOk: function() {
            // get value of contentType
            contentTypeObj = this.getContentElement('contentTypeSelectionTab','contentType');

            contentTypeVal = contentTypeObj.getValue();
            //var plusButton = editor.getSelection().getStartElement().$;
            var plusButton = editor.plusButton;


            if (contentTypeVal != '' && $(plusButton).length > 0 && $(plusButton).hasClass('templateEditor')) {
                // contentTypeVal might be 'p' or 'p.lead'
                contentTypeVal = contentTypeVal.split('.');

                contentTypeTag = contentTypeVal[0];
                contentTypeTagClass = '';

                if(contentTypeVal.length == 2) {
                    // we have a tag and class name e.g. p.lead
                    contentTypeTagClass = ' class="' + contentTypeVal[1] + '"';
                }

                // create DOM element if value of contentType is set and a plus button was clicked
                var newElement = '';
                switch(contentTypeTag)
                {
                    case 'btn-xtlive':
                        newElement = $('<p><a class="btn-xtlive" href="#" contenteditable="true">Button Text</a></p>');
                        break;
                    case 'btn-xtlive-big':
                        newElement = $('<p><a class="btn-xtlive-big" href="#" contenteditable="true">Button Text</a></p>');
                        break;
                    default:
                        newElement = $('<' + contentTypeTag + contentTypeTagClass + ' style="border: thin dashed grey;" contenteditable="true">Lorem ipsum dolor sit amet</' + contentTypeTag + '>');
                        break;
                }

                $(plusButton).after($(newElement));
                editor.execCommand('templateEditor');
                editor.execCommand('templateEditor');
            }

        }
    };
} );