/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */
;
(function ($) {

    /*! Tiny Pub/Sub - v0.7.0 - 2013-01-29
     * https://github.com/cowboy/jquery-tiny-pubsub
     Copyright (c) 2014 "Cowboy" Ben Alman; Licensed MIT */
    var o = $({});
    $.subscribe = function () {
        o.on.apply(o, arguments);
    };

    $.unsubscribe = function () {
        o.off.apply(o, arguments);
    };

    $.publish = function () {
        o.trigger.apply(o, arguments);
    };
}(jQuery));

CKEDITOR.editorConfig = function (config) {
    // Define changes to default configuration here.
    // For the complete reference:
    // http://docs.ckeditor.com/#!/api/CKEDITOR.config

    // The toolbar groups arrangement, optimized for two toolbar rows.
    config.toolbarGroups = [
        {name: 'clipboard', groups: ['clipboard', 'undo']},
        {name: 'editing', groups: ['find', 'selection', 'spellchecker']},
        {name: 'links'},
        {name: 'insert'},
        {name: 'forms'},
        {name: 'tools'},
        {name: 'document', groups: ['mode', 'document', 'doctools']},
        {name: 'others'},
        '/',
        {name: 'basicstyles', groups: ['basicstyles', 'cleanup']},
        {name: 'paragraph', groups: ['list', 'indent', 'blocks', 'align', 'bidi']},
        {name: 'styles'},
        {name: 'colors'},
        {name: 'about'}
    ];

    // Remove some buttons, provided by the standard plugins, which we don't
    // need to have in the Standard(s) toolbar.
    config.removeButtons = 'Underline,Subscript,Superscript';

    // Set the most common block elements.
    config.format_tags = 'p;h1;h2;h3;pre';

    // Simplify the dialog windows.
    config.removeDialogTabs = 'image:advanced;link:advanced;link:upload;image:Upload';


// ************ XTLIVE extensions ************* //

    config.contentsCss = [CKEDITOR.getUrl(CKEDITOR.basePath + '../../../../plugins/xtlive_manager/templates/admin/css/backend.css'), CKEDITOR.getUrl(CKEDITOR.basePath + '../../../../plugins/xtlive_elements/css/xtlive-elements_xt5.css')];

    // new for 4.5.9: allow all html elements/classes/styles except some specific ones
    // @link: http://docs.ckeditor.com/#!/guide/dev_disallowed_content-section-how-to-allow-everything-except...
    //config.allowedContent = true;
    config.allowedContent = {
        $1: {
            // Use the ability to specify elements as an object.
            elements: CKEDITOR.dtd,
            attributes: true,
            styles: true,
            classes: true
        }
    };
    // new for 4.5.9: do not allow width, height, margin, border in style-attribute
    config.disallowedContent = 'img[width,height]{border*,margin*,width,height}';
    //config.extraAllowedContent = 'div[*](*){*}; section(*); header(*); script[*]; iframe[*](*){*}; figure(*)[*]; figcaption(*)[*]; img(img-responsive)[data-smarty]; h1(*); h2(*); h3(*); h4(*); p(*); span(*); button[*](*); a[*](*)';

    config.enableTemplateEditor = true;
    //config.extraPlugins = 'youtube,justify,moveContentLeft,moveContentRight,inlineEditing,widget,lineutils,clipboard,shopWidget,textPic,templateEditor';
    config.extraPlugins = 'moveContentLeft,moveContentRight,inlineEditing,widget,shopWidget,textPic,templateEditor';
    config.bodyClass = 'ckeditor-backend-area';
    // autostart SCYAT
    config.scayt_autoStartup = false;
    config.scayt_sLang = 'de_DE';
};

/**
 * remove inline style attribute value from img tags to ensure responsive images in ckeditor view
 * this rules only apply when instance is loaded (on save/open of new ckeditor instance)
 */
CKEDITOR.on('instanceReady', function (ev) {
    ev.editor.execCommand("inlineEditing");
    ev.editor.execCommand("templateEditor");
    ev.editor.resetUndo();

    // fire inlineEditing on change
    ev.editor.on('mode', function (event) {
        event.editor.execCommand("inlineEditing");
        event.editor.execCommand("templateEditor");
        event.editor.execCommand("templateEditor");
        event.editor.resetUndo();
    });

    ev.editor.dataProcessor.htmlFilter.addRules({
        elements: {
            $: function (element) {
                if (element.attributes.contenteditable === "true") {
                    element.attributes.contenteditable = false;
                    element.attributes.style = "";
                }

                if (element.name === "img") {
                    element.attributes.style = "";
                }

                if (element.name == "span" && element.hasClass('templateEditor')) {
                    delete element.name;
                }
            }
        }
    });
    ev.editor.dataProcessor.dataFilter.addRules({
        elements: {
            $: function (element) {
                if (element.attributes.contenteditable === "true") {
                    element.attributes.contenteditable = false;
                    element.attributes.style = "";
                }

                if (element.name === "img") {
                    element.attributes.style = "";
                }

                if (element.name == "span" && element.hasClass('templateEditor')) {
                    delete element.name;
                }
            }
        }
    });

    ev.editor.on('beforeCommandExec', function (ev) {
        if (ev.data.name == "unlink") {
            anchor = CKEDITOR.plugins.link.getSelectedLink(ev.editor);
            if (anchor != null) {
                anchor.remove(1);
            }
        }
    });
});


/**
 * allow span tags to be empty (for icons)
 */
CKEDITOR.dtd.$removeEmpty['span'] = 0;

/**
 * allow div tags to be empty (for styles)
 */
CKEDITOR.dtd.$removeEmpty['div'] = false;

/**
 * allow a > div
 */
CKEDITOR.dtd.a.div = 1;

// ************ XTLIVE extensions ************* //

var scripts;

$.ajax({
    url: '../index.php?page=xtlive_elements&page_action=getExternalScripts',
    async: false,
    success: function(response) {
        scripts = response;
    }
});

if (scripts && scripts.length > 0) {
    CKEDITOR.scriptLoader.load(scripts);
}

