<?php

function disableXtLive() {
    global $db, $logHandler;

    $msg = 'XtLive IoncubeErrorHandler: disabling XTLIVE due to licensing error';
    $logHandler->_addLog('info', 'xtlive_elements', 0, array('error_code' => '0', 'message' => $msg));

    require_once _SRV_WEBROOT . _SRV_WEB_FRAMEWORK . 'classes/class.plugin_installed.php';
    $pluginManager = new plugin_installed();

    // disable xtlive products including their hookpoints
    $status = 0;
    if (($id = $pluginManager->checkInstall('xtlive_manager'))) {
        $db->Execute(
        "update " . TABLE_PLUGIN_PRODUCTS . " set plugin_status = ? where plugin_id = ?",
        array($status, $id)
        );
        $db->Execute(
        "update " . TABLE_PLUGIN_CODE . " set plugin_status = ? where plugin_id = ?",
        array($status, $id)
        );
        $msg = 'XtLive IoncubeErrorHandler: xtlive_manager was disabled due to licensing error';
        $logHandler->_addLog('info', 'xtlive_elements', 0, array('error_code' => '0', 'message' => $msg));
    }
    if (($id = $pluginManager->checkInstall('xtlive_elements'))) {
        $db->Execute(
        "update " . TABLE_PLUGIN_PRODUCTS . " set plugin_status = ? where plugin_id = ?",
        array($status, $id)
        );
        $db->Execute(
        "update " . TABLE_PLUGIN_CODE . " set plugin_status = ? where plugin_id = ?",
        array($status, $id)
        );
        $msg = 'XtLive IoncubeErrorHandler: xtlive_elements was disabled due to licensing error';
        $logHandler->_addLog('info', 'xtlive_elements', 0, array('error_code' => '0', 'message' => $msg));
    }
    // disable demo content
    if (xtLiveFieldExists("content_demo_mode", TABLE_CONTENT)) {
        $db->Execute("update " . TABLE_CONTENT . " set content_status = 0 where content_demo_mode = 1");

        // remove demo content in categories menu
        $query = "SELECT cat.categories_id from " . DB_PREFIX . "_categories cat " .
        "INNER JOIN " . DB_PREFIX . "_content c on (cat.category_custom_link_id = c.content_id and c.content_demo_mode = 1) " .
        "WHERE cat.category_custom_link = 1 AND cat.category_custom_link_type = 'content' and cat.categories_level = 1";

        $rs = $db->Execute($query);
        if ($rs->RecordCount() > 0) {
            while (!$rs->EOF) {
                $cat = new category();
                $extJsObj = $cat->_unset($rs->fields['categories_id']);

                if (!$extJsObj->success) {
                    $msg = 'XtLive IoncubeErrorHandler: could not remove link to xtlive demo pages in categories menu';
                    $logHandler->_addLog('error', 'xtlive_elements', 0, array('error_code' => '0', 'message' => $msg));
                }
                $query = "DELETE FROM " . DB_PREFIX . "_categories_custom_link_url where categories_id = ?";
                $db->Execute($query, array($rs->fields['categories_id']));

                $rs->MoveNext();
            }
        }
    }

    // cleanup filesystem
    $destFile = _SRV_WEBROOT.'conf/.htaccess';
    unlink($destFile);

    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/moveContentLeft');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/moveContentRight');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/inlineEditing');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/lineutils');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/widget');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/shopWidget');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/textPic');
    xtLiveRecursiveRemove(_SRV_WEBROOT._SRV_WEB_FRAMEWORK.'library/ckeditor/4.5.9/plugins/templateEditor');

}

function xtLiveFieldExists($field,$table) {
    global $db,$filter;

    $table = $filter->_charNum($table);
    $field = $filter->_charNum($field);

    $colExists = $db->GetOne("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='"._SYSTEM_DATABASE_DATABASE."' AND COLUMN_NAME='".$field."' AND TABLE_NAME='".$table."'");

    return $colExists;
}

function xtLiveRecursiveRemove($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (is_dir($dir."/".$object))
                    xtLiveRecursiveRemove($dir."/".$object);
                else
                    unlink($dir."/".$object);
            }
        }
        rmdir($dir);
    }
}