CKEDITOR.plugins.add('moveContentRight', {
    icons: 'moveContentRight',
    init: function(editor) {
        editor.addCommand('moveContentRight', {
            exec: function(editor) {
                var $startElement = $(editor.getSelection().getStartElement().$),
                    $moveElement = $startElement.closest('.moveable');

                if($moveElement && $moveElement.length > 0){
                    var $nextElement = $moveElement.next('.moveable');

                    if($nextElement && $nextElement.length > 0){
                        var $element1 = $moveElement.clone();
                        var $element2 = $nextElement.clone();

                        $moveElement.replaceWith($element2);
                        $nextElement.replaceWith($element1);

                        editor.widgets.checkWidgets()
                    }else{
                        alert("You cant move to right");
                    }
                }else{
                    alert("No '.moveable' class found");
                }
            }
        });

        editor.ui.addButton('moveContentRight', {
            label: 'Move Element Right',
            command: 'moveContentRight',
            toolbar: 'others,1'
        });

    }
});