CKEDITOR.plugins.add('inlineEditing', {
    icons: 'inlineEditing',
    init: function(editor) {
        editor.addCommand('inlineEditing', {
            exec: function(editor) {
                var startElement = editor.getSelection().getStartElement();               
                var notEditable  = startElement;
                var editable     = startElement;


				contentEditableElements = ".editable :header, .editable p, .editable img, .editable figcaption, .editable a";
				contentEditableExcludeElements = ".editable .widget :header, .editable .widget p";

                if(notEditable != null && $(".editable", editor.getData()).length > 0){
                    // Disable all
                    while(!notEditable.hasClass("cke_editable")){
                        notEditable = notEditable.getParent();
                    }   
                    $(notEditable.$).attr("contenteditable","false");
                    editable = $(notEditable.$);
                    
                    if($(contentEditableElements, editable).attr("contenteditable") == "true"){
                        $(contentEditableElements, editable).attr("contenteditable","false");
                        $("* [contenteditable='false']", editable).css("border", "");
                    }else{                        
						$(contentEditableElements, editable).attr("contenteditable","true");
						// exclude widgets
						$(contentEditableExcludeElements, editable).attr("contenteditable","false");
                        $("* [contenteditable='true']", editable).css("border", "thin dashed grey");
                    }
                }
            }
        });

        /*editor.ui.addButton('inlineEditing', {
            label: 'inlineEditing',
            command: 'inlineEditing',
            toolbar: 'others'
        });*/

    }
});
