CKEDITOR.plugins.add( 'textPic', {
    requires: 'widget',
    icons: 'textPic',

    init: function( editor ) {
        CKEDITOR.dialog.add( 'textPic', this.path + 'dialogs/textPic.js' );

        editor.widgets.add( 'textPic', {
            //button: 'textPic',
            /*template:
             '<div class="widget row">' +
             '<div class="col-md-12">' +
             '<h3>Header...</h3>' +
             '<p>Einträge... </p>' +
             '</div>' +
             '</div>',*/
            editables: {
                content: {
                    selector: 'section.textPic-image',
                    allowedContent: 'img[*](*)'
                }
            },
            /*allowedContent:
             'div(!widget); div(!row); div(!col-md-12); h3',
             requiredContent: 'div(widget)',*/

            dialog: "textPic",

            upcast: function( element ) {
                return element.name == 'div' && element.hasClass( 'textPic-widget' );
            },

            init: function(){
                var pattern = /([A-Za-z_]+)=('((.|\s)+?)'|[^\s]+)/g;
                var data_smarty = $(this.element.$).attr("data-smarty");

                // parsing data-smarty and set values
                while((m = pattern.exec(data_smarty)) !== null) {
                    if(m[1] === "box_type"){
                        this.setData('box_type', m[2].replace(/'/g,""));
                    }else if(m[1] === "image"){
                        this.setData('image', m[2].replace(/'/g,""));
                    }else if(m[1] === "label"){
                        this.setData('label', m[2].replace(/'/g,""));
                    }else if(m[1] === "link"){
                        this.setData('link', m[2].replace(/'/g,""));
                    }else if(m[1] === "header"){
                        this.setData('header', m[2].replace(/'/g,""));
                    }else if(m[1] === "text"){
                        this.setData('text', m[2].replace(/'/g,""));
                    }else if(m[1] === "tpl"){
                        this.setData('tpl', m[2].replace(/'/g,""));
                    }
                }

                this.setData('src','content:' + $(this.element.$).find('img').attr('src').match(/[^/]+\.[a-z]+$/g));
                this.setData('alt',$(this.element.$).find('img').attr('alt'));

                // set tabIndex
                if(this.data.box_type == "textPic"){
                    this.setData('tabIndex', 0);
                }
            },

            data: function() {
                var html = "";
                if(typeof this.data.tabIndex  != "undefined"){
                    switch(this.data.tabIndex){
                        case 0:
                            var label = "", link = "", header = "", text = "", tpl = "";

                            if(typeof this.data.label == "undefined"){this.data.label = "";}
                            if(typeof this.data.link == "undefined"){this.data.link = "";}
                            if(typeof this.data.header == "undefined"){this.data.header = "";}
                            if(typeof this.data.text == "undefined"){this.data.text = "";}
							if(typeof this.data.tpl == "undefined"){this.data.tpl = "";}
							if(typeof this.data.src == "undefined"){this.data.src = "";}

                            if(this.data.label != "") {html += '<strong>Label: </strong>' + this.data.label + ' <br />';}
                            if(this.data.link != "") {html += '<strong>Link: </strong><a>' + this.data.link + '</a>';}

                            if (this.data.label != ""){label = " label='" + this.data.label + "'";}
                            if (this.data.link != ""){link = " link='" + this.data.link + "'";}
                            if (this.data.header != ""){header = " header='" + this.data.header + "'";}
                            if (this.data.text != ""){text = " text='" + this.data.text + "'";}
                            if (this.data.tpl != ""){tpl = " tpl='" + this.data.tpl + "'";}
							if (this.data.src != ""){src = " src='" + this.data.src + "'";}

                            $(".lbl",this.element.$).html(html);
                            $(":header",this.element.$).text(this.data.header);
                            $(".content",this.element.$).html(this.data.text);

                            // setting data-smarty attribute
                            $(this.element.$).attr("data-smarty", "{box name=xtlive_elements box_type='" + this.data.box_type + "'" + label + link + header + text + tpl + src + " type=user}");
                            break;
                    }
                }
            },
            draggable: false
        });

        editor.widgets.on('instanceCreated', function(evt){
            var widget = evt.data;
            widget.on('key', function(event){
                // lock backspace and delete button
                if(event.data.keyCode == 8 || event.data.keyCode == 46){
                    event.cancel();
                }
            });
        });

        editor.on('dialogShow', function ( evt ) {
            if ( evt.data.getName() == 'image' && evt.editor.widgets.widgetHoldingFocusedEditable !== null ) {
                var editor = evt.editor;
                var listener = evt.data.on( 'ok', function() {
                    editor.widgets.widgetHoldingFocusedEditable.setData('src', 'content:' + $(this.originalElement.$).attr('src').match(/[^/]+\.[a-z]+$/g));    
                });

                evt.data.on( 'hide', function() {
                    listener.removeListener();
                });
            }
        });

    }
});